package com.agilex.healthcare.veteranappointment.datalayer.appointment;

import javax.annotation.Resource;

import org.junit.Test;

import com.agilex.healthcare.veteranappointment.utils.SpringBasedIntegrationRepo;
import com.agilex.healthcare.veteranappointment.domain.VARAppointmentRequestInProcess;

public class AppointmentRequestInProcessDataLayerRepoTest extends SpringBasedIntegrationRepo {
	
	@Resource
	AppointmentRequestInProcessDataLayerRepo dataLayer;
	
	@Test
 	public void testSaveAppointmentRequestInProcess() {
		VARAppointmentRequestInProcess arInProcess = createSampleAppointmentRequestInProcess("arInProcess1");
		
		VARAppointmentRequestInProcess savedRequest = dataLayer.saveAppointmentRequestInProcess(arInProcess);
		
		assertAppointmentRequestInProcess(arInProcess, savedRequest);
	}

	private void assertAppointmentRequestInProcess(VARAppointmentRequestInProcess arInProcess,
			VARAppointmentRequestInProcess savedRequest) {
		assertEquals(arInProcess.getAppointmentRequestId(), savedRequest.getAppointmentRequestId());
		assertEquals(arInProcess.getUserId(), savedRequest.getUserId());
		assertEquals(arInProcess.getFirstName(), savedRequest.getFirstName());
		assertEquals(arInProcess.getLastName(), savedRequest.getLastName());
	}
	
	@Test
	public void validateRetrievalOfAppointmentRequestInProcessById(){
		VARAppointmentRequestInProcess arInProcess = createSampleAppointmentRequestInProcess("arInProcess1");
		dataLayer.saveAppointmentRequestInProcess(arInProcess);
		
		VARAppointmentRequestInProcess retrievedARInProcess = dataLayer.fetchAppointmentRequestInProcessByAppointmentRequestId(arInProcess.getAppointmentRequestId());

		assertAppointmentRequestInProcess(arInProcess, retrievedARInProcess);
	}

	@Test
	public void validateDeletionOfAppointmentRequestInProcessById(){
		VARAppointmentRequestInProcess arInProcess = createSampleAppointmentRequestInProcess("arInProcess1");
		dataLayer.saveAppointmentRequestInProcess(arInProcess);

		dataLayer.deleteAppointmentRequestInProcessById(arInProcess.getAppointmentRequestId());
		VARAppointmentRequestInProcess retrievedARInProcess = dataLayer.fetchAppointmentRequestInProcessByAppointmentRequestId(arInProcess.getAppointmentRequestId());
		
		assertNull(retrievedARInProcess);
	}
	

	@Test
	public void validateDeletionOfAppointmentRequestsInProcessByUserId(){
		VARAppointmentRequestInProcess arInProcess1 = createSampleAppointmentRequestInProcess("arInProcess1");
		VARAppointmentRequestInProcess arInProcess2 = createSampleAppointmentRequestInProcess("arInProcess2");
		
		dataLayer.saveAppointmentRequestInProcess(arInProcess1);
		dataLayer.saveAppointmentRequestInProcess(arInProcess2);

		dataLayer.deleteAppointmentRequestInProcessByUserId(arInProcess1.getUserId());
		VARAppointmentRequestInProcess retrievedARInProcess1 = dataLayer.fetchAppointmentRequestInProcessByAppointmentRequestId(arInProcess1.getAppointmentRequestId());
		VARAppointmentRequestInProcess retrievedARInProcess2 = dataLayer.fetchAppointmentRequestInProcessByAppointmentRequestId(arInProcess2.getAppointmentRequestId());
		
		assertNull(retrievedARInProcess1);
		assertNull(retrievedARInProcess2);

	}
	

	private VARAppointmentRequestInProcess createSampleAppointmentRequestInProcess(String id) {
		VARAppointmentRequestInProcess arInProcess = new VARAppointmentRequestInProcess();
		arInProcess.setAppointmentRequestId(id);
		arInProcess.setUserId("john.smith");
		arInProcess.setFirstName("John");
		arInProcess.setLastName("Smith");
		return arInProcess;
	}
	

}
